// 受信バッファーのチェック
int serial_available() {
  if (! debug_noserial) {
    if (Wireless) {
      return 0;   // 未実装
    } else {
      return myPort.available();
    }
  }
  return 0;
}

// 8bitのcharデータの受信
char serial_read() {
  if (debug_noserial) {
    return (char) -1;
  } else {
    if (serial_available() > 0) {
      if (Wireless) {
        return (char) -1;  // 未実装
      } else {
        return (char)myPort.read();
      }
    }
  }
  return (char) -1;
}

// 8bitのcharデータの送信
void serial_write(char c) {
  if (debug_preventdumping && rc.current_command_flag == c) return;  // リスクのある処理（同じコマンドは重複して送信しない）
  if(debug || debug_noserial) println("serial:" + binary(c, 8));
  if (! debug_noserial) {
    if (Wireless) {
      // 未実装
    } else {
      myPort.write(c);
    }
  }
  rc.current_command_flag = c;  // 最後に送信したコマンドを記憶
}

// 8bitのbyte配列データの送信
void serial_write(byte[] b) {
  for (int i = 0; i < b.length; i++) serial_write((char)b[i]);
}

// 通信プロトコル２用（将来）
void serial_write2byte(int a) {
  byte [] ba = {0, 0};
  ba[1] = (byte)((a & 0x07f) & 0b01111111);
  ba[0] = (byte)(((a >> 7) & 0b01111111) | 0b10000000);
  serial_write(ba);
}
// 異常時は -1 を返す
// デバッグ時(debug_noserial)は0を返す
// serial_available()が0より大きい状態で呼ぶこと．
int serial_read2byte() {
  byte [] ba = {0, 0};
  int     t0 = millis();
  int     ret;
  
  if (debug_noserial) return 0;
  while (serial_available() == 0) {
    if ((millis() - t0) > 100) return -1;  // 100[ms]
  }
  ba[0] = (byte)serial_read();
  if ((ba[0] & 0b10000000) == 0b10000000) return -1;  // 1byte目のデータではない
  while (serial_available() == 0) {
    if ((millis() - t0) > 100) return -1;  // 100[ms]
  }
  ba[1] = (byte)serial_read();
  if ((ba[0] & 0b10000000) == 0b00000000) return -1;  // 2byte目のデータではない
  ret = ba[0];
  ret = ret << 7;
  ret |= (ba[1] & 0b01111111);
  return ret;
}
